/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: UStaticCppDrv98.cpp,v 1.1 1999/09/12 04:33:32 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "UStaticCpp.h"

_USING_PGP

_UNNAMED_BEGIN

// Types

typedef void (_cdecl *PtrVoidFunc)(void);

struct AtExitEntry
{
	PtrVoidFunc func;
	AtExitEntry *next;
};

// Static variables

AtExitEntry *AtExitEntryList = NULL;

_UNNAMED_END


// Exported variables

#pragma data_seg("INITAAAA")
PtrVoidFunc	__xc_a[]	= {NULL};
#pragma data_seg()

#pragma data_seg("INITZZZZ")
PGPUInt32	_aZero		= 0;
#pragma data_seg()


// Functions

int 
_cdecl 
atexit(PtrVoidFunc func)
{
	AtExitEntry	*newEntry;

	newEntry = new AtExitEntry;

	if (IsNull(newEntry))
		return 0;

	newEntry->func = func;

	newEntry->next = AtExitEntryList;
	AtExitEntryList = newEntry;

	return 1;
}

void 
UStaticCpp::CallGlobalConstructors()
{
	PtrVoidFunc	*pfbegin;

	pfbegin = __xc_a;

	while (TRUE)
	{
		++pfbegin;

		if (*pfbegin == NULL)
			break;

		(**pfbegin)();
	}
}

void 
UStaticCpp::CallGlobalDestructors()
{
	AtExitEntry	*curEntry, *nextEntry;

	curEntry = AtExitEntryList;

	while (IsntNull(curEntry))
	{
		curEntry->func();
		nextEntry = curEntry->next;
		delete curEntry;
		curEntry = nextEntry;
	}
}
